%% CIS II Galen Kinematic Calibration 
%% Can Kocabalkanli, Spring 2020
%% Please refer to the CIS II Report for documentation and explanations

% Get data from delta trajectory
[C, K, k_dof] = get_data_1();
% Get data from wrist trajectory
[Cw, Kw, k_dof_w] = get_data_w1();
%K_AMBF = get_sanity_data();
N = size(k_dof,1);
W = size(k_dof_w,1);

% Initiate variables
e_dof = zeros(6,1,N);
E = zeros(4,4,N);
A = zeros(4,4,W);
B = zeros(4,4,W);
A2 = zeros(4,4,W);
B2 = zeros(4,4,W);
K_pre = zeros(4,4,N); 
K_new = zeros(4,4,N); 
E_bp = zeros(4,4,N);

iter = 0;
terminate = 0;

while terminate == 0
    % Hand-Eye Calibration
    for r = 1:W
        A(:,:,r) = Cw(:,:,r)/(Cw(:,:,1));
        B(:,:,r) = Kw(:,:,r)/(Kw(:,:,1));
        A2(:,:,r) = Cw(:,:,1)\Cw(:,:,r);
        B2(:,:,r) = Kw(:,:,1)\Kw(:,:,r);  
    end
    
   % Solve AX=XB Problem
   T_b = axxb(A, B);
   T_tip = inv(axxb(A2, B2));
   
   %T_tip = [eye(3) -[-70.617; 0; -147.345]; 0 0 0 1];
   %T_b = [eye(3) -[-0.09; 0.147; 0.446]*1000; 0 0 0 1];

    % Calculate K_pre
    K_pre = calculate_K_pre(T_b, C, T_tip);
    K_pre_W = calculate_K_pre(T_b, Cw, T_tip);
        
    % Calculate small error  
    for r = 1:N  
        E(:,:,r) = K(:,:,r)\K_pre(:,:,r); %inv(K)*K_pre
        e_dof(:,r) = skew2vector(E(:,:,r)); 
        if r <= W
            Ew(:,:,r) = Kw(:,:,r)\K_pre_W(:,:,r);
            e_dof_w(:,r) = skew2vector(Ew(:,:,r)); 
        end
    end
    
    e_dof_s = squeeze(e_dof);
    e_dof_ws = squeeze(e_dof_w);
    
    % Plot K and K_pre for Visual Comparison
    x = squeeze(K(1,4,:));
    y = squeeze(K(2,4,:));
    z = squeeze(K(3,4,:));
    xp = squeeze(K_pre(1,4,:));
    yp = squeeze(K_pre(2,4,:));
    zp = squeeze(K_pre(3,4,:));
    scatter3(x,y,z);
    hold on;
    scatter3(xp,yp,zp);
    
    % Correct XYZ HERE
    [S, qmax, qmin, delta_cor_2D] = correct3D(k_dof(:,1:3), e_dof_s(1:3,:)'); %with error vectors
    
    %correct WRIST HERE
    [S_wrist, qmax_wrist, qmin_wrist, wrist_cor_2D] = correct3D([k_dof_w(:,4:5) zeros(W,1)], e_dof_ws(4:6,:)'); %with error vectors

    %%%%% Correction Using New Error %%%%%
    e_cor = [delta_cor_2D zeros(N,2)];% wrist_cor_2D]; %if using error
    e_cor_w = [zeros(W,3) wrist_cor_2D];
    norm_error = zeros(N,1);
    old_error = zeros(N,1);
    
    % Calculate corrected K_new for delta trajectory
    for r = 1:N  
        E_bp(:,:,r) = vector2skew([e_cor(r,:) 0]); %turns DOF to frame
        K_new(:,:,r) = K(:,:,r)*E_bp(:,:,r); 
        
        % Evaluate errors
        F = K_new(:,:,r) - K_pre(:,:,r);
        G = K(:,:,r)  - K_pre(:,:,r);
        norm_error(r) = norm(F(1:3,4));
        old_error(r) = norm(G(1:3,4));
       
    end
    
    % Calculate corrected K_new for wrist trajectory
    for r = 1:W
        Ew_bp(:,:,r) = vector2skew([e_cor_w(r,:) 0]);
        Kw_new(:,:,r) = Kw(:,:,r)*Ew_bp(:,:,r); 
        F2 = Kw_new(:,:,r)/K_pre_W(:,:,r);         
        G2 = Kw(:,:,r)/K_pre_W(:,:,r);
     
        f2 = skew2vector(F2);
        g2 = skew2vector(G2);
     
        dof_error_test(r) = norm(f2(4:6));
        dof_error_old(r) = norm(g2(4:6));
    end
    
    % Check if error is small enough or similar enough to previous error to
    % terminate
    mean_prev = mean(old_error)
    if (max(norm_error)< 1.5 && mean(norm_error)< 0.5) || (0.97*mean_prev < mean(norm_error)<2) || (1.03*mean_prev > mean(norm_error)<2)
        terminate = 1;
    end    
    mean_prev = mean(norm_error);
    max_prev = max(norm_error);
    
end

%% Test Correction Function on Test Data

[C_test, K_test, k_dof_test_2D] = get_test_data_2();
M = size(k_dof_test_2D, 1);   

% Workspace boundaries qmax and qmin are the same as the dataset the
% polynomial is fitted to
qmax = [qmax; qmax_wrist];
qmin = [qmin; qmax_wrist];
%qmax = [max(k_dof(:,1)) ; max(k_dof(:,2)) ; max(k_dof(:,3))];
%qmin = [min(k_dof(:,1)) ; min(k_dof(:,2)) ; min(k_dof(:,3))];

norm_error_test = zeros(M,1);
old_error_test = zeros(M,1);
K_test_correct = zeros(4,4,M);
E_bp_test = zeros(4,4,M);
K_new_test = zeros(4,4,M);

% Calculate K_pre
K_pre_test = calculate_K_pre(T_b, C_test, T_tip);

%Plot K_pre and K for test dataset, for visual comparison
    x = squeeze(K_test(1,4,:));
    y = squeeze(K_test(2,4,:));
    z = squeeze(K_test(3,4,:));
    xp = squeeze(K_pre_test(1,4,:));
    yp = squeeze(K_pre_test(2,4,:));
    zp = squeeze(K_pre_test(3,4,:));
    scatter3(x,y,z);
    hold on;
    scatter3(xp,yp,zp);

% Apply Correction Polynomial to each pose, and calculate delta_K_BP and 
% Corrected transformation
 for i = 1:M
     
    k_dof_test = k_dof_test_2D(i,:);
    delta_error_dof = correctDistortion(k_dof_test(1:3), qmax(1:3), qmin(1:3), S); %change to S_delta

    %test_error_dof(i,:) = [delta_error_dof' wrist_error_dof'];
    test_error_dof(i,:) = [delta_error_dof' zeros(1,2)];
    
     E_bp_test(:,:,i) = vector2skew([test_error_dof(i,:) 0]); %turns DOF to frame
     K_new_test(:,:,i) = K_test(:,:,i)*E_bp_test(:,:,i); 
        
     % Quantify errors   
     F = K_new_test(:,:,i) - K_pre_test(:,:,i);
     G = K_test(:,:,i)  - K_pre_test(:,:,i);
     norm_error_test(i) = norm(F(1:3,4));
     old_error_test(i) = norm(G(1:3,4));     
 end
 
 


%% Plot corrected K_new for visual comparison
hold on;
xn = squeeze(K_new_test(1,4,:));
yn = squeeze(K_new_test(2,4,:));
zn = squeeze(K_new_test(3,4,:));
scatter3(xn,yn,zn);
hold on;
scatter3(xp, yp, zp);
% Display Errors
disp(max(old_error_test))
disp(max(norm_error_test))
disp(mean(old_error_test))
disp(mean(norm_error_test))



%% Correct Wrist Trajectory
[C_test_w, K_test_w, k_dof_test_2D_w] = get_test_data_w2();

V = size(k_dof_test_2D_w,1);
dof_error_test = zeros(V,1);
dof_error_old = zeros(V,1);
test_error_w_dof =  zeros(V,6);
E_bp_w = zeros(4,4,V);
Kw_new_test = zeros(4,4,V);

Kw_pre_test = calculate_K_pre(T_b, C_test_w, T_tip);
 for i = 1:V
     
     k_dof_test = k_dof_test_2D_w(i,:);
     wrist_error_dof = correctDistortion([k_dof_test(4:5) 0], qmax_wrist, qmin_wrist, S_wrist);
     test_error_w_dof(i,:) = [0; 0; 0; wrist_error_dof];
     E_bp_w(:,:,i) = vector2skew([test_error_w_dof(i,:) 0]);
     Kw_new_test(:,:,i) = K_test_w(:,:,i)*E_bp_w(:,:,i); 
     
     F2 = Kw_new_test(:,:,i)/Kw_pre_test(:,:,i);         
     G2 = K_test_w(:,:,i)/Kw_pre_test(:,:,i);
     
     f2 = skew2vector(F2);
     g2 = skew2vector(G2);
     
     dof_error_test(i) = norm(f2(4:6));
     dof_error_old(i) = norm(g2(4:6)); %very small, so K_test_w and Kw_pre_test are good
 end
 
 %Display angular errors
 disp(mean(dof_error_old))
 disp(max(dof_error_old))
 disp(mean(dof_error_test))
 disp(max(dof_error_test))